<!DOCTYPE html>
<?php 
include ('includes/header.php');?>
<html>
<head>
    <meta charset="utf-8">
    <title>PHP JSON File CRUD (Create Read Update and Delete)</title>
    <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css">
</head>
<body>
<?php
    //get id from URL
    $index = $_GET['index'];
 
    //get json data
    $data = file_get_contents('api/RTXSettings.json');
    $data_array = json_decode($data);
 
    //assign the data to selected index
    $row = $data_array->RTX_MODE[$index];
 
    if(isset($_POST['save'])){
        $input = array(
            'SettingName' => $_POST['SettingName'],
            'Action' => $_POST['Action']
        );
 
        //update the selected index
        $data_array->RTX_MODE[$index] = $input;
 
        //encode back to json
        $data = json_encode($data_array, JSON_PRETTY_PRINT);
        file_put_contents('api/RTXSettings.json', $data);
        $index = "";
        //header('location: appsetting.php');
        echo "<script>window.location.href='appsetting.php';</script>";
        exit;
    }
?>
<div class="container">
    <h1 class="page-header text-center">PHP JSON File CRUD (Create Read Update and Delete)</h1>
    <div class="row">
        <div class="col-1"></div>
        <div class="col-8"><a href="appsetting.php">Back</a>
        <form method="POST">
            <div class="mb-3 row">
                <label class="col-sm-2 col-form-label">SettingName</label>
                <div class="col-sm-10">
                    <input type="text" class="form-control" id="SettingName" name="SettingName" value="<?php echo $row->SettingName; ?>">
                </div>
            </div>
            <div class="mb-3 row">
                <label class="col-sm-2 col-form-label">Action</label>
                <div class="col-sm-10">
                    <input type="text" class="form-control" id="Action" name="Action" value="<?php echo $row->Action; ?>">
                </div>
            </div>
            <input type="submit" name="save" value="Save" class="btn btn-primary">
        </form>
        </div>
        <div class="col-5"></div>
    </div>
</div>   
<?php include ('includes/footer.php');?>
</body>
</html>